function [ y ] = Heun_NA( f, y0, t, h, N )

% function [ y ] = Heun_NA( f, y0, t, h, N )
% This function uses the Heun method to solve numerically an
% ODE of the type "y' = f(t,y)" for a given initial condition "y0".
% The numerical solution is obtained on a uniform mesh of "N+1" points
% and size "h".
% INPUT:
% f  : function handle for the RHS of the ODE;
% y0 : initial condition;
% t  : vector of discretized time;
% h  : mesh size;
% N  : number of mesh points.
% OUTPUT:
% y  : discrete solution.

% Initialize "y";
y = zeros(N+1,1);

% Assign initial condition;
y(1) = y0;

% Compute the discrete approximation;
for j = 1 : N
    y_bar = y(j) + h * f(t(j),y(j));
    y(j+1) = y(j) + h/2 * ( f(t(j),y(j)) + f(t(j+1),y_bar) );
end

end