function [ A, b, c ] = radau5_coefficients()

% function [ A, b, c ] = radau5_coefficients()
% Purpose: Returns the coefficients of the Radau IIa method.
% Created:     2025.12.05
% Last change: 2025.12.07

sqrt6 = sqrt(6);

c = [(4 - sqrt6)/10;
     (4 + sqrt6)/10;
      1];

A = [  (88 - 7*sqrt6)/360,   (296 - 169*sqrt6)/1800, (-2 + 3*sqrt6)/225;
       (296 + 169*sqrt6)/1800, (88 + 7*sqrt6)/360,   (-2 - 3*sqrt6)/225;
       (16 - sqrt6)/36,      (16 + sqrt6)/36,        1/9 ];

b = A(end,:);

end