function [ u, t ] = Explicit_Euler( u0, A, T, Nt )

	Nx = size(u0,1);
	
	h = T/Nt;
	t = h*(0:Nt)';
	
	u = zeros(Nx,Nt+1);
	u(:,1) = u0(:);
	
	for i=1:Nt
		u(:,i+1) = (eye(Nx) + h*A) * u(:,i);
	end

	return
end