function [ R ] = computeRKStabilityRegion(A, b, Z)

% function [ R ] = computeRKStabilityRegion(A, b, Z)
% Purpose: Computes |R(z)| for a Runge-Kutta method given by Butcher tableau.
% Created:     2025.12.02
% Last change: 2025.12.02

% INPUT:
% A  : Runge-Kutta matrix;
% b  : vector of weights;
% Z  : a meshgrid for the complex plane.
% OUTPUT:
% R  : discrete stability region.

%   Dec 2, 2025:
%       Created.

s = length(b);
I = eye(s);
onesvec = ones(s,1);

R = zeros(size(Z));

% Compute the stability function on the whole grid
for k = 1:numel(Z)
    z = Z(k);
    R(k) = 1 + z * (b' * ((I - z*A) \ onesvec));
end

end